
/*:

@target MZ
@plugindesc ウィンドウのフレームを変更します。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_AltWindowFrame.js

このプラグインはメロウ紙芝居がツクールMVのウィンドウビルダーの
「AltWindowFrame.js(著者:KADOKAWA)」を改変した物です。
プラグイン管理のMK_Managers.jsよりも一番下に置こう。

動作確認コアスクリプト: v1.2.0

*/

(() => {
    
    //画像プリロード
    const _Scene_Boot_loadSystemImages = Scene_Boot.prototype.loadSystemImages;
    Scene_Boot.prototype.loadSystemImages = function() {
        _Scene_Boot_loadSystemImages.apply(this, arguments);
        ImageManager.loadSystem('Window_Battle');
        ImageManager.loadSystem('Window_Talk');
        ImageManager.loadSystem('Window_Status');
        ImageManager.loadSystem('Window_Other');
        ImageManager.loadSystem('Window_Other2');
    };
    
    
    /////////////////自作プラグインの元々オブジェクト/////////////////
    
    const _MK_StageSelect_Scene_Create = MK_StageSelect_Scene.prototype.create;
    MK_StageSelect_Scene.prototype.create = function() {
        _MK_StageSelect_Scene_Create.apply(this, arguments);
        const _image = ImageManager.loadSystem(!$gameSwitches.value(52) ? "Window_Other" : "Window_Other2");
        this.mk_stageSelect_window_title._windowskin = _image;
        this.mk_stageSelect_window_score._windowskin = _image;
        this.mk_stageSelect_window_option._windowskin = _image;
        this.mk_stageSelect_window_picture._windowskin = _image;
        this.mk_stageSelect_window._windowskin = _image;
        
        this.mk_stageSelect_window_title._refreshAllParts();
        this.mk_stageSelect_window_score._refreshAllParts();
        this.mk_stageSelect_window_option._refreshAllParts();
        this.mk_stageSelect_window_picture._refreshAllParts();
        this.mk_stageSelect_window._refreshAllParts();
    };
    
    const _MK_WordWindow_Window_initialize = MK_WordWindow_Window.prototype.initialize;
    MK_WordWindow_Window.prototype.initialize = function() {
        _MK_WordWindow_Window_initialize.apply(this, arguments);
        this.windowskin = ImageManager.loadSystem('Window_Battle');
        this._refreshAllParts();
    };

    
    /////////////////元々オブジェクト/////////////////
    
    //----------シーン----------

    const _Scene_Title_Create = Scene_Title.prototype.create;
    Scene_Title.prototype.create = function() {
        _Scene_Title_Create.apply(this, arguments);
        this._commandWindow._windowskin = ImageManager.loadSystem('Window_Status');
        this._commandWindow._refreshAllParts();
    };
    
    const _Scene_Menu_Create = Scene_Menu.prototype.create;
    Scene_Menu.prototype.create = function() {
        _Scene_Menu_Create.apply(this, arguments);
        const _image = ImageManager.loadSystem('Window_Status');
        this._commandWindow._windowskin = _image;
        
        this._commandWindow._refreshAllParts();
    };
    
    const _Scene_Options_Create = Scene_Options.prototype.create;
    Scene_Options.prototype.create = function() {
        _Scene_Options_Create.apply(this, arguments);
        this._optionsWindow._windowskin = ImageManager.loadSystem('Window_Status');
        this._optionsWindow._refreshAllParts();
    };
    
    //----------ウィンドウ----------
    
    const _Window_NameBox_Initialize = Window_NameBox.prototype.initialize;
    Window_NameBox.prototype.initialize = function() {
        _Window_NameBox_Initialize.apply(this, arguments);
        this.windowskin = ImageManager.loadSystem('Window_Talk');
        this._refreshAllParts();
    };
    
    const _Window_ChoiceList_Initialize = Window_ChoiceList.prototype.initialize;
    Window_ChoiceList.prototype.initialize = function() {
        _Window_ChoiceList_Initialize.apply(this, arguments);
        this.windowskin = ImageManager.loadSystem('Window_Talk');
        this._refreshAllParts();
    };
    
    const _Window_Message_Initialize = Window_Message.prototype.initialize;
    Window_Message.prototype.initialize = function() {
        _Window_Message_Initialize.apply(this, arguments);
        this.windowskin = ImageManager.loadSystem('Window_Talk');
        this._refreshAllParts();
    };
    
    
    /////////////////元々オブジェクト コア/////////////////
    
    Window.prototype._refreshBack = function() {
        const m = this._margin + 6;
        const w = Math.max(0, this._width - m * 2);
        const h = Math.max(0, this._height - m * 2);
        const sprite = this._backSprite;
        const bitmap = new Bitmap(w, h);
        
        sprite.bitmap = null;
        sprite.bitmap = bitmap;
        sprite.setFrame(0, 0, w, h);
        sprite.move(m, m);
        sprite.setColorTone(this._colorTone);
        
        if (w > 0 && h > 0 && this._windowskin) {
            const p = 192;
            for (let y = 0; y < h; y += p) {
                for (let x = 0; x < w; x += p) {
                    bitmap.blt(this._windowskin, 0, p, p, p, x, y, p, p);
                }
            }
        }
        
    };
    
    Window.prototype._refreshFrame = function() {
        const w = this._width;
        const h = this._height;
        const m = 24;
        const bitmap = new Bitmap(w, h);

        this._frameSprite.bitmap = null;
        this._frameSprite.bitmap = bitmap;
        this._frameSprite.setFrame(0, 0, w, h);

        if (w > 0 && h > 0 && this._windowskin) {
            const skin = this._windowskin;

            // frame
            const p = 96;
            const q = 96;
            bitmap.blt(skin, p+0,   0+0,   m,     m,     0,   0,   m,     m);       // left top corner
            bitmap.blt(skin, p+0,   0+q-m, m,     m,     0,   h-m, m,     m);       // left bottom corner
            bitmap.blt(skin, p+q-m, 0+0,   m,     m,     w-m, 0,   m,     m);       // right top corner
            bitmap.blt(skin, p+q-m, 0+q-m, m,     m,     w-m, h-m, m,     m);       // right bottom corner

            const frameHeight = 48;
            const heightCount = Math.floor((h-frameHeight) / frameHeight);
            let remainder = (h-frameHeight) % frameHeight;            
            for(let i = 0; i < heightCount; i++) {
                bitmap.blt(skin, p+0,   0+m, m, p-m*2, 0,   m+frameHeight*i, m, frameHeight);   // left frame
                bitmap.blt(skin, p+q-m, 0+m, m, p-m*2, w-m, m+frameHeight*i, m, frameHeight);   // right frame
            }
            if(remainder != 0) {
                bitmap.blt(skin, p+0,   0+m, m, remainder, 0,   m+frameHeight*heightCount, m, remainder);   // left frame
                bitmap.blt(skin, p+q-m, 0+m, m, remainder, w-m, m+frameHeight*heightCount, m, remainder);   // right frame
            }

            const frameWidth = 48;
            const widthCount = Math.floor((w-frameWidth) / frameWidth);
            remainder = (w-frameWidth) % frameWidth;
            for(let j = 0; j < widthCount; j++) {
                bitmap.blt(skin, p+m,   0+0,   p-m*2, m, m+frameWidth*j, 0,   frameWidth, m); // top frame
                bitmap.blt(skin, p+m,   0+q-m, p-m*2, m, m+frameWidth*j, h-m, frameWidth, m); // bottom frame
            }
            if(remainder != 0) {
                bitmap.blt(skin, p+m,   0+0,   remainder, m, m+frameWidth*widthCount, 0,   remainder, m); // top frame                
                bitmap.blt(skin, p+m,   0+q-m, remainder, m, m+frameWidth*widthCount, h-m, remainder, m); // bottom frame
            }

            // corner
            const r = 48;
            const s = 48;
            bitmap.blt(skin, 0,   0+q*4, r, s, 0,   0,   r, s); // left top
            bitmap.blt(skin, r,   0+q*4, r, s, w-r, 0,   r, s); // right top
            bitmap.blt(skin, r*2, 0+q*4, r, s, 0,   h-r, r, s); // left bottom
            bitmap.blt(skin, r*3, 0+q*4, r, s, w-r, h-r, r, s); // right bottom
        }
        
    };
    
})();
